//
//  NSData+TTTCrypto.m
//  Tic-Tac-Toe-Storyboard
//
//  Created by Rajiv Ramnath on 11/24/13.
//  Copyright (c) 2013 Rajiv Ramnath. All rights reserved.
//

#import "NSData+TTTCrypto.h"

@implementation NSData (TTTCrypto)
#import <CommonCrypto/CommonCryptor.h>
#import "NSData+TTTCrypto.h"

- (NSData *)encode :(NSString *)inputKey :(int)encryptionOp{

    char key[kCCKeySizeAES256+1];
    bzero(key, sizeof(key));
    
    // Copy key into the character array upto the maximum size of the key
    [inputKey getCString:key maxLength:sizeof(key) encoding:NSUTF8StringEncoding];
    
    size_t allocatedSize = self.length + kCCBlockSizeAES128;
    void *output = malloc(allocatedSize);
    
    size_t actualSize = 0;
    CCCryptorStatus resultCode = CCCrypt(encryptionOp, kCCAlgorithmAES128,
                                         kCCOptionPKCS7Padding, key, kCCKeySizeAES256, nil, self.bytes, self.length, output, 
                                         allocatedSize, &actualSize);
    
    if (resultCode != kCCSuccess){
        // Free the output buffer
        free(output);
        return nil;
    }
    
    return [NSData dataWithBytesNoCopy:output length:actualSize];
}

- (NSData *)encryptWithKey:(NSString *)key{
    return [self encode :key :kCCEncrypt];
}

- (NSData *)decryptWithKey:(NSString *)key{
    return [self encode :key :kCCDecrypt];
}

@end
